"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "fetchAllFromScroll", {
  enumerable: true,
  get: function () {
    return _fetch_all_from_scroll.fetchAllFromScroll;
  }
});
exports.isAuthorized = isAuthorized;
Object.defineProperty(exports, "wrapForCustomError", {
  enumerable: true,
  get: function () {
    return _wrap_elasticsearch_error.wrapForCustomError;
  }
});
var _lodash = require("lodash");
var _fetch_all_from_scroll = require("./fetch_all_from_scroll");
var _wrap_elasticsearch_error = require("./wrap_elasticsearch_error");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

function isAuthorized(result, authHeaderName = 'authorization') {
  const credentials = (0, _lodash.get)(result, `meta.request.params.headers${authHeaderName}`, '');
  return !!credentials.length;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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